<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class ModuleAccessMiddleware
{
    public function handle(Request $request, Closure $next, $module)
    {
        $user = $request->user();

        if (!$user || !$user->hasModuleAccess($module)) {
            return response()->json(['message' => 'Unauthorized access to this module'], 403);
        }

        return $next($request);
    }
}
