<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Business extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'person_name',
        'company_name',
        'email',
        'mobile',
        'linkedin_url',
        'purpose',
        'size',
        'notes',
        'next_followup_date',
        'created_by',
    ];

    protected $casts = [
        'next_followup_date' => 'date',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function assignedTo()
    {
        return $this->belongsToMany(User::class, 'business_assignments', 'business_id', 'user_id')
            ->withTimestamps();
    }

    public function teams()
    {
        // Deprecated
        return $this->assignedTo();
    }

    public function scopeOverdueFollowups($query)
    {
        return $query->whereNotNull('next_followup_date')
            ->whereDate('next_followup_date', '<', now());
    }
}
