<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Lead extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'person_name',
        'company_name',
        'email',
        'mobile',
        'size',
        'notes',
        'lead_quality',
        'purpose',
        'status',
        'next_followup_date',
        'is_imported',
        'is_accepted',
        'is_accepted',
        'linkedin_url',
        'created_by',
    ];

    protected $casts = [
        'next_followup_date' => 'date',
        'is_imported' => 'boolean',
        'is_accepted' => 'boolean',
    ];
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function assignedTo()
    {
        return $this->belongsToMany(User::class, 'lead_assignments', 'lead_id', 'user_id')
            ->withPivot('accepted_at', 'rejected_at')
            ->withTimestamps();
    }

    public function teams()
    {
        // Deprecated, keeping for safety until full cleanup
        return $this->assignedTo(); 
    }

    public function scopePriority($query)
    {
        return $query->where('lead_quality', 'priority');
    }

    public function scopeRejected($query)
    {
        return $query->whereHas('assignedTo', function ($q) {
            $q->whereNotNull('rejected_at');
        });
    }

    public function scopeOverdueFollowups($query)
    {
        return $query->whereNotNull('next_followup_date')
            ->whereDate('next_followup_date', '<', now());
    }
}
