<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'company_name',
        'contact_person',
        'mobile',
        'purpose',
        'deadline',
        'status',
        'notes',

        'investor_lead_id',
        'created_by',
    ];

    protected $casts = [
        'deadline' => 'date',

    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function assignedTo()
    {
        return $this->belongsToMany(User::class, 'project_assignments', 'project_id', 'user_id')
            ->withTimestamps();
    }

    public function teams()
    {
        // Deprecated
        return $this->assignedTo();
    }

    public function tasks()
    {
        return $this->hasMany(Task::class);
    }

    public function scopeOngoing($query)
    {
        return $query->where('status', 'ongoing');
    }

    public function scopeCompleted($query)
    {
        return $query->where('status', 'completed');
    }

    public function investor()
    {
        return $this->belongsTo(Lead::class, 'investor_lead_id');
    }
}
