<?php

namespace App\Services;

use App\Models\Lead;
use PhpOffice\PhpSpreadsheet\IOFactory;

class LeadImportService
{
    public function importFromExcel($filePath, $teamIds, $createdBy)
    {
        $spreadsheet = IOFactory::load($filePath);
        $worksheet = $spreadsheet->getActiveSheet();
        $rows = $worksheet->toArray();

        $imported = 0;
        $errors = [];

        // Skip header row
        foreach (array_slice($rows, 1) as $index => $row) {
            $rowNumber = $index + 2; // +2 because we skipped header and arrays are 0-indexed

            try {
                // Validate required fields
                if (empty($row[0]) || empty($row[1]) || (empty($row[2]) && empty($row[3]))) {
                    $errors[] = "Row {$rowNumber}: Missing required fields (person name, company name, or contact info)";
                    continue;
                }

                $lead = Lead::create([
                    'person_name' => $row[0],
                    'company_name' => $row[1],
                    'email' => $row[2] ?? '',
                    'mobile' => $row[3] ?? '',
                    'size' => $row[4] ?? null,
                    'notes' => $row[5] ?? null,
                    'lead_quality' => $row[6] ?? 'general',
                    'purpose' => $row[7] ?? null,
                    'status' => $row[8] ?? 'new',
                    'linkedin_url' => $row[9] ?? null,
                    'next_followup_date' => isset($row[10]) ? date('Y-m-d', strtotime($row[10])) : null,
                    'lead_type' => 'investor',
                    'is_imported' => true,
                    'is_accepted' => null,
                    'created_by' => $createdBy,
                ]);

                // Assign to Heads (user_ids)
                if (!empty($teamIds)) {
                    $lead->assignedTo()->attach($teamIds);
                }

                $imported++;
            } catch (\Exception $e) {
                $errors[] = "Row {$rowNumber}: " . $e->getMessage();
            }
        }

        return [
            'imported' => $imported,
            'errors' => $errors,
        ];
    }
}
