<?php

use App\Models\User;
use Illuminate\Support\Facades\Hash;

require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$email = 'admin@valmiki.com';
$password = 'password';

$user = User::where('email', $email)->first();

if (!$user) {
    echo "User not found!\n";
    exit(1);
}

echo "User found: " . $user->name . "\n";
echo "Stored Hash: " . $user->password . "\n";

if (Hash::check($password, $user->password)) {
    echo "Password match: YES\n";
} else {
    echo "Password match: NO\n";
    echo "New Hash would be: " . Hash::make($password) . "\n";
}
