<?php
// Create database script for Valmiki CRM

try {
    // Connect to MySQL without selecting a database
    $pdo = new PDO('mysql:host=127.0.0.1;port=3306', 'root', '');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Create database if it doesn't exist
    $pdo->exec("CREATE DATABASE IF NOT EXISTS valmiki_crm CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    
    echo "✓ Database 'valmiki_crm' created successfully!\n";
    
    // Verify database exists
    $stmt = $pdo->query("SHOW DATABASES LIKE 'valmiki_crm'");
    if ($stmt->rowCount() > 0) {
        echo "✓ Database verified!\n";
    }
    
} catch (PDOException $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    exit(1);
}
