<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();
            $table->string('person_name');
            $table->string('company_name');
            $table->string('email')->unique();
            $table->string('mobile', 15)->unique();
            $table->string('size')->nullable();
            $table->text('notes')->nullable();
            $table->enum('lead_quality', ['general', 'priority'])->default('general');
            $table->string('purpose')->nullable();
            $table->enum('status', ['new', 'follow-up', 'lost', 'open'])->default('new');
            $table->date('next_followup_date')->nullable();
            $table->boolean('is_imported')->default(false);
            $table->boolean('is_accepted')->nullable();
            $table->foreignId('created_by')->constrained('users')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};
