<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Drop pivot tables first due to foreign key constraints
        Schema::dropIfExists('team_user');
        Schema::dropIfExists('business_team');
        Schema::dropIfExists('lead_team');
        Schema::dropIfExists('project_team');
        
        // Drop teams table
        Schema::dropIfExists('teams');

        // Create team_members table (Hierarchy)
        Schema::create('team_members', function (Blueprint $table) {
            $table->id();
            $table->foreignId('head_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('member_id')->constrained('users')->onDelete('cascade');
            $table->timestamps();
            
            $table->unique(['head_id', 'member_id']);
        });

        // Create assignment tables
        Schema::create('lead_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lead_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // The Head
            $table->timestamp('accepted_at')->nullable();
            $table->timestamp('rejected_at')->nullable();
            $table->timestamps();
            
            $table->unique(['lead_id', 'user_id']);
        });

        Schema::create('business_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('business_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // The Head
            $table->timestamps();
            
            $table->unique(['business_id', 'user_id']);
        });

        Schema::create('project_assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('project_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // The Head
            $table->timestamps();
            
            $table->unique(['project_id', 'user_id']);
        });
    }

    public function down(): void
    {
        Schema::table('user_hierarchy', function (Blueprint $table) {
            //
        });
    }
};
