<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->string('project_status')->nullable()->after('status');
            $table->date('target_deadline')->nullable()->after('deadline');
            $table->string('target_investor')->nullable()->after('contact_person');
            // We'll also add an optional relation if strictly needed, but text was requested.
        });
    }

    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropColumn(['project_status', 'target_deadline', 'target_investor']);
        });
    }
};
