<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // 1. Leads Table Changes
        Schema::table('leads', function (Blueprint $table) {
            if (Schema::hasColumn('leads', 'lead_type')) {
                $table->dropColumn('lead_type');
            }
        });

        // 2. Businesses Table Changes
        Schema::table('businesses', function (Blueprint $table) {
            if (!Schema::hasColumn('businesses', 'linkedin_url')) {
                $table->string('linkedin_url')->nullable()->after('mobile');
            }
        });

        // 3. Projects Table Changes
        Schema::table('projects', function (Blueprint $table) {
            if (Schema::hasColumn('projects', 'target_investor')) {
                $table->dropColumn('target_investor');
            }
            if (!Schema::hasColumn('projects', 'investor_lead_id')) {
                // Assuming 'leads' is the investor leads table
                $table->foreignId('investor_lead_id')->nullable()->constrained('leads')->nullOnDelete();
            }
        });
    }

    public function down(): void
    {
        Schema::table('leads', function (Blueprint $table) {
            $table->string('lead_type')->default('investor')->nullable(); // Revert
        });

        Schema::table('businesses', function (Blueprint $table) {
            $table->dropColumn('linkedin_url');
        });

        Schema::table('projects', function (Blueprint $table) {
            $table->string('target_investor')->nullable();
            $table->dropForeign(['investor_lead_id']);
            $table->dropColumn('investor_lead_id');
        });
    }
};
