<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\Project;
use Illuminate\Support\Facades\DB;

$query = 'abc';

DB::enableQueryLog();

$projectQuery = Project::where(function ($q) use ($query) {
    $q->where('company_name', 'like', "%{$query}%")
        ->orWhere('contact_person', 'like', "%{$query}%")
        ->orWhere('mobile', 'like', "%{$query}%")
        ->orWhere('purpose', 'like', "%{$query}%");
});

echo "Generated SQL:\n";
echo $projectQuery->toSql() . "\n";
echo "Bindings:\n";
print_r($projectQuery->getBindings());

$projects = $projectQuery->get();

echo "\nResult Count: " . $projects->count() . "\n";

if ($projects->count() > 0) {
    echo "First Project:\n";
    print_r($projects->first()->toArray());
}
