<?php
// Comprehensive MySQL password finder
$hosts = ['127.0.0.1', 'localhost'];
$user = 'root';
$dbname = 'valmiki_crm';

// Extended password list
$passwords = [
    '',           // Empty
    'root',       // Common default
    'password',   // Common default
    'admin',      // Common default  
    'mysql',      // Common default
    '123456',     // Weak common
    'toor',       // Reverse of root
    'valmiki',    // Project name
    'kaku',       // From path E:\kaku\valmiki
];

echo "=== MySQL Password Finder ===\n\n";

foreach ($hosts as $host) {
    echo "Testing host: $host\n";
    echo str_repeat("-", 50) . "\n";
    
    foreach ($passwords as $pass) {
        try {
            $dsn = "mysql:host=$host;port=3306";
            $pdo = new PDO($dsn, $user, $pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            echo "✓ CONNECTED with password: '" . ($pass ?: '(empty)') . "'\n";
            echo "  Host: $host\n";
            
            // Try to select the database
            try {
                $pdo->exec("USE $dbname");
                echo "  ✓ Database '$dbname' accessible\n";
                
                // Count tables
                $stmt = $pdo->query("SHOW TABLES");
                $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
                echo "  ✓ Tables found: " . count($tables) . "\n";
                if (count($tables) > 0) {
                    echo "  ✓ Table list: " . implode(', ', $tables) . "\n";
                }
            } catch (PDOException $e) {
                echo "  ⚠ Database exists but error: " . $e->getMessage() . "\n";
            }
            
            echo "\n✓✓✓ SUCCESS! Update your .env file:\n";
            echo "DB_HOST=$host\n";
            echo "DB_PASSWORD=" . $pass . "\n\n";
            exit(0);
            
        } catch (PDOException $e) {
            $displayPass = $pass ?: '(empty)';
            echo "  ✗ '$displayPass': " . substr($e->getMessage(), 0, 80) . "...\n";
        }
    }
    echo "\n";
}

echo "\n❌ Could not connect with any tested password.\n";
echo "Please check your MySQL installation or try resetting the password.\n";
