<?php

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\User;

echo "=== CRM Users ===\n\n";
echo str_pad("ID", 5) . str_pad("Name", 25) . str_pad("Email", 35) . "Role\n";
echo str_repeat("-", 80) . "\n";

$users = User::with('role')->get();

foreach ($users as $user) {
    echo str_pad($user->id, 5) . 
         str_pad($user->name, 25) . 
         str_pad($user->email, 35) . 
         $user->role->name . "\n";
}

echo "\n=== Team Member Relationships ===\n\n";

$heads = User::whereHas('role', function($q) {
    $q->where('name', 'head');
})->with('members')->get();

foreach ($heads as $head) {
    echo "Head: {$head->name} ({$head->email})\n";
    if ($head->members->count() > 0) {
        echo "  Team Members:\n";
        foreach ($head->members as $member) {
            echo "    - {$member->name} ({$member->email})\n";
        }
    } else {
        echo "  No team members assigned\n";
    }
    echo "\n";
}

echo "\nNote: Default password for seeded users is usually 'password'\n";
