<?php
// Script to read DB_PASSWORD from .env
$envFile = __DIR__ . '/.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (strpos(trim($line), '#') === 0) continue;
        if (strpos($line, 'DB_PASSWORD=') === 0) {
            $parts = explode('=', $line, 2);
            $password = isset($parts[1]) ? trim($parts[1]) : '';
            echo "Found password in .env: '" . $password . "'\n";
            exit(0);
        }
    }
    echo "DB_PASSWORD not found in .env\n";
} else {
    echo ".env file not found\n";
}
