# PowerShell script to reset MySQL password using --init-file
$initFile = "c:\Users\CHAUDHARI VATSAL\.gemini\antigravity\scratch\valmiki-crm\backend\mysql_init.sql"

Write-Host "Stopping MySQL..."
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL with init file..."
# We use --console to see output if possible, but Start-Process hides it unless we redirect
# We don't use --skip-grant-tables because we want to execute ALTER USER
$proc = Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -ArgumentList "--defaults-file=C:\xampp\mysql\bin\my.ini", "--init-file=$initFile", "--console" -PassThru -WindowStyle Hidden

Write-Host "Waiting for password reset (15 seconds)..."
Start-Sleep -Seconds 15

Write-Host "Stopping MySQL..."
Stop-Process -Id $proc.Id -Force -ErrorAction SilentlyContinue
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL normally..."
Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -WindowStyle Hidden
Start-Sleep -Seconds 5

Write-Host "Testing connection..."
php test_mysql_connection.php
