# PowerShell script to reset MySQL password to 'root'
Write-Host "Stopping MySQL..."
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL in safe mode..."
$safeModeProcess = Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -ArgumentList "--skip-grant-tables" -PassThru -WindowStyle Hidden
Start-Sleep -Seconds 8

if (Get-Process -Id $safeModeProcess.Id -ErrorAction SilentlyContinue) {
    Write-Host "MySQL is running (PID: $($safeModeProcess.Id))"
    
    Write-Host "Resetting password to 'root'..."
    $commands = @"
FLUSH PRIVILEGES;
ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY 'root';
ALTER USER 'root'@'127.0.0.1' IDENTIFIED WITH mysql_native_password BY 'root';
FLUSH PRIVILEGES;
EXIT;
"@
    $commands | & "C:\xampp\mysql\bin\mysql.exe" -u root
    
} else {
    Write-Host "MySQL failed to start!"
}

Write-Host "Stopping safe mode..."
Stop-Process -Id $safeModeProcess.Id -Force -ErrorAction SilentlyContinue
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL normally..."
Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -WindowStyle Hidden
Start-Sleep -Seconds 5

Write-Host "Testing connection with password 'root'..."
php test_mysql_connection.php
