# PowerShell script to reset MySQL password
Write-Host "Stopping MySQL..."
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL in safe mode..."
$safeModeProcess = Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -ArgumentList "--skip-grant-tables","--skip-networking" -PassThru -WindowStyle Hidden
Start-Sleep -Seconds 5

Write-Host "Resetting password..."
# Using mysql_native_password to avoid plugin issues
$commands = @"
FLUSH PRIVILEGES;
ALTER USER 'root'@'localhost' IDENTIFIED WITH mysql_native_password BY '';
ALTER USER 'root'@'127.0.0.1' IDENTIFIED WITH mysql_native_password BY '';
FLUSH PRIVILEGES;
EXIT;
"@

$commands | & "C:\xampp\mysql\bin\mysql.exe" -u root

Write-Host "Stopping safe mode..."
Stop-Process -Id $safeModeProcess.Id -Force -ErrorAction SilentlyContinue
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL normally..."
# Start mysqld as a background process
Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -WindowStyle Hidden
Start-Sleep -Seconds 5

Write-Host "Testing connection..."
php test_mysql_connection.php
