# PowerShell script to reset MySQL password using PHP
Write-Host "Stopping MySQL..."
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL in safe mode..."
$safeModeProcess = Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -ArgumentList "--skip-grant-tables","--skip-networking" -PassThru -WindowStyle Hidden
Start-Sleep -Seconds 5

Write-Host "Running PHP reset script..."
php php_reset_password.php

Write-Host "Stopping safe mode..."
Stop-Process -Id $safeModeProcess.Id -Force -ErrorAction SilentlyContinue
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL normally..."
Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -WindowStyle Hidden
Start-Sleep -Seconds 5

Write-Host "Testing connection..."
php test_mysql_connection.php
