# PowerShell script to reset MySQL password using PHP (v4)
Write-Host "Stopping MySQL..."
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL in safe mode (networking enabled)..."
# Removed --skip-networking to allow TCP connection
$safeModeProcess = Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -ArgumentList "--skip-grant-tables" -PassThru -WindowStyle Hidden
Start-Sleep -Seconds 8

if (Get-Process -Id $safeModeProcess.Id -ErrorAction SilentlyContinue) {
    Write-Host "MySQL is running (PID: $($safeModeProcess.Id))"
    
    Write-Host "Running PHP reset script..."
    php php_reset_password.php
} else {
    Write-Host "MySQL failed to start!"
}

Write-Host "Stopping safe mode..."
Stop-Process -Id $safeModeProcess.Id -Force -ErrorAction SilentlyContinue
Stop-Process -Name "mysqld" -Force -ErrorAction SilentlyContinue
Start-Sleep -Seconds 2

Write-Host "Starting MySQL normally..."
Start-Process -FilePath "C:\xampp\mysql\bin\mysqld.exe" -WindowStyle Hidden
Start-Sleep -Seconds 5

Write-Host "Testing connection..."
php test_mysql_connection.php
