@echo off
echo ========================================
echo Valmiki CRM - Backend Setup Script
echo ========================================
echo.

REM Set PHP path from XAMPP
set PHP_PATH=C:\xampp\php\php.exe

REM Check if PHP exists
if not exist "%PHP_PATH%" (
    echo ERROR: PHP not found at %PHP_PATH%
    echo Please install XAMPP or update the PHP_PATH in this script
    pause
    exit /b 1
)

echo [1/6] Checking PHP version...
"%PHP_PATH%" --version
echo.

echo [2/6] Installing Composer dependencies...
echo This may take a few minutes...
"%PHP_PATH%" -r "copy('https://getcomposer.org/installer', 'composer-setup.php');"
"%PHP_PATH%" composer-setup.php
"%PHP_PATH%" -r "unlink('composer-setup.php');"
"%PHP_PATH%" composer.phar install
echo.

echo [3/6] Generating application key...
"%PHP_PATH%" artisan key:generate
echo.

echo [4/6] Creating database...
echo Please ensure MySQL is running in XAMPP Control Panel
echo Then create database 'valmiki_crm' in phpMyAdmin (http://localhost/phpmyadmin)
echo.
pause

echo [5/6] Running database migrations...
"%PHP_PATH%" artisan migrate
echo.

echo [6/6] Seeding database with demo data...
"%PHP_PATH%" artisan db:seed
echo.

echo ========================================
echo Setup Complete!
echo ========================================
echo.
echo Default Login Credentials:
echo - Admin: admin@valmiki.com / password
echo - Head: head@valmiki.com / password
echo - Team: team@valmiki.com / password
echo.
echo To start the backend server, run:
echo %PHP_PATH% artisan serve
echo.
pause
