<?php
// Direct connection test with empty password
echo "Testing MySQL connection with EMPTY password...\n\n";

$configs = [
    ['host' => '127.0.0.1', 'port' => '3306'],
    ['host' => 'localhost', 'port' => '3306'],
];

foreach ($configs as $config) {
    $host = $config['host'];
    $port = $config['port'];
    
    echo "Testing: {$host}:{$port}\n";
    echo str_repeat("-", 50) . "\n";
    
    try {
        // Test 1: Connection without database
        $dsn = "mysql:host={$host};port={$port}";
        $pdo = new PDO($dsn, 'root', '');
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        echo "✓ Connected to MySQL server!\n";
        
        // Test 2: Check if database exists
        $stmt = $pdo->query("SHOW DATABASES LIKE 'valmiki_crm'");
        if ($stmt->rowCount() > 0) {
            echo "✓ Database 'valmiki_crm' exists\n";
            
            // Test 3: Try to use the database
            $pdo->exec("USE valmiki_crm");
            echo "✓ Successfully selected database\n";
            
            // Test 4: Check tables
            $stmt = $pdo->query("SHOW TABLES");
            $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
            echo "✓ Tables in database: " . count($tables) . "\n";
            
            if (count($tables) > 0) {
                echo "  Tables: " . implode(', ', $tables) . "\n";
            } else {
                echo "  ⚠ No tables found - migrations may not have run\n";
            }
            
            // Test 5: Try to query users table
            try {
                $stmt = $pdo->query("SELECT COUNT(*) as count FROM users");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                echo "✓ Users table accessible, count: " . $result['count'] . "\n";
            } catch (PDOException $e) {
                echo "  ⚠ Users table issue: " . $e->getMessage() . "\n";
            }
            
        } else {
            echo "✗ Database 'valmiki_crm' does not exist\n";
        }
        
        echo "\n✓✓✓ CONNECTION SUCCESSFUL!\n";
        echo "MySQL is working correctly with empty password.\n";
        echo "The issue must be elsewhere.\n\n";
        exit(0);
        
    } catch (PDOException $e) {
        echo "✗ Connection failed: " . $e->getMessage() . "\n\n";
    }
}

echo "❌ Could not connect to MySQL with empty password.\n";
echo "This is strange since you said the password is blank.\n";
