<?php
// Test MySQL connection with different password scenarios

$hosts = ['127.0.0.1', 'localhost'];
$port = '3306';
$user = 'root';
$dbname = 'valmiki_crm';

$passwords = ['', 'root', 'password', 'admin', 'mysql'];

echo "Testing MySQL connection...\n\n";

foreach ($hosts as $h) {
    echo "Testing host: $h\n";
    foreach ($passwords as $pass) {
        try {
            $dsn = "mysql:host=$h;port=$port;dbname=$dbname";
            $pdo = new PDO($dsn, $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        echo "✓ SUCCESS! Connected with password: '" . ($pass ?: '(empty)') . "'\n";
        echo "  Database: $dbname\n";
        
        // Test query
        $stmt = $pdo->query("SELECT COUNT(*) as count FROM information_schema.tables WHERE table_schema = '$dbname'");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "  Tables found: " . $result['count'] . "\n";
        
        // Show tables
        $stmt = $pdo->query("SHOW TABLES");
        $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
        if (count($tables) > 0) {
            echo "  Table names: " . implode(', ', $tables) . "\n";
        }
        
        echo "\n✓ Use this password in your .env file!\n";
        exit(0);
        
    } catch (PDOException $e) {
        echo "✗ Failed with password '" . ($pass ?: '(empty)') . "': " . $e->getMessage() . "\n";
    }
    }
}

echo "\n✗ Could not connect with any common password.\n";
echo "Please check your MySQL root password in XAMPP.\n";
