<?php

require __DIR__ . '/vendor/autoload.php';

$client = new \GuzzleHttp\Client(['base_uri' => 'http://127.0.0.1:8000/api/', 'http_errors' => false]);

echo "1. Logging in...\n";
$response = $client->post('auth/login', [
    'json' => [
        'email' => 'admin@valmiki.com',
        'password' => 'password'
    ]
]);

$data = json_decode($response->getBody(), true);

if ($response->getStatusCode() !== 200 || !isset($data['token'])) {
    echo "Login failed!\n";
    echo "Status Code: " . $response->getStatusCode() . "\n";
    echo "Response Body: " . $response->getBody() . "\n";
    exit(1);
}

$token = $data['token'];
echo "Login successful! Token obtained.\n\n";

echo "2. Searching for 'abc'...\n";
$response = $client->get('search?query=abc', [
    'headers' => [
        'Authorization' => 'Bearer ' . $token,
        'Accept' => 'application/json'
    ]
]);

$searchResults = json_decode($response->getBody(), true);

echo "Search Results:\n";
echo "Projects Count: " . count($searchResults['projects']) . "\n";
if (count($searchResults['projects']) > 0) {
    echo "First Project:\n";
    print_r($searchResults['projects'][0]);
}
echo "Leads Count: " . count($searchResults['leads']) . "\n";
echo "Businesses Count: " . count($searchResults['businesses']) . "\n";
